// Replace the control names/ids with the proper names of the desired fields
var m_fldSubTotal=document.getElementById("cur_910_cur_910_Line_Item_Total");
var m_fldSubTotalb=document.getElementById("cur_910_cur_910_Line_Item_Total_readonly");
var m_fldQuantity=document.getElementById("nbr_908_nbr_908_Line_Item_Quantity");
var m_fldUnitPrice=document.getElementById("cur_909_cur_909_Line_Item_Unit_Price");
var m_fldUnitPriceb=document.getElementById("cur_909_cur_909_Line_Item_Unit_Price_readonly")


var strRegExDelimiter = new RegExp("\\"+g_MqRef.RESX['CURRENCY.THOUSANDS'], "g");
var strRegExDecimal = new RegExp("\\"+g_MqRef.RESX['CURRENCY.DECIMAL'], "g");

SetOnChange1(m_fldSubTotal,"UnitPrice_CalcFlds();");
SetOnChange1(m_fldQuantity,"UnitPrice_SubTotal_CalcFlds();");
SetOnChange1(m_fldUnitPrice,"SubTotal_CalcFlds();");

function UnitPrice_CalcFlds()
{
	//Calculations for when updating the SubTotal
	if (m_fldUnitPrice){
		if (m_fldQuantity.value != "")
		{
			var uPrice;
			if(isNaN(m_fldSubTotal.value) || isNaN(m_fldQuantity.value) || m_fldQuantity.value == 0 || m_fldQuantity.value == "") 
			{
				uPrice = Number("0.00");
			}
			else
			{
				uPrice = parseFloat(m_fldSubTotal.value).toFixed(2) / Number(m_fldQuantity.value);
			}
				m_fldUnitPrice.value= uPrice;
				
			//Format the Unit Price currency value
			m_fldUnitPrice.value = parseFloat(m_fldUnitPrice.value).toFixed(2);
			m_fldUnitPriceb.innerHTML = g_MqRef.RESX['CURRENCY.SYMBOL'] + " " + parseFloat(m_fldUnitPrice.value)
													.toFixed(2)
													.toString()
													.replace(/\./g, g_MqRef.RESX['CURRENCY.DECIMAL']) 
													.replace(/\B(?=(\d{3})+(?!\d))/g, g_MqRef.RESX['CURRENCY.THOUSANDS']);
			
			m_fldUnitPrice.value = parseFloat(m_fldUnitPrice.value)
													.toFixed(2)
													.toString()
													.replace(/\./g, g_MqRef.RESX['CURRENCY.DECIMAL']) 
													.replace(/\B(?=(\d{3})+(?!\d))/g, g_MqRef.RESX['CURRENCY.THOUSANDS']);
			//m_fldSubTotal.onchange();
		}
	}
	return;
}

function SubTotal_CalcFlds()
{
	//Calculations for when updating the Unit Price
	if (m_fldSubTotal){
		if (m_fldQuantity.value != "")
		{
			var subPrice;
			if(isNaN(m_fldUnitPrice.value.replace(strRegExDelimiter, "").replace(strRegExDecimal, ".")) || isNaN(m_fldQuantity.value) || m_fldQuantity.value == "")
			{
				subPrice = Number("0.00");
			}
			else
			{
				subPrice = parseFloat(m_fldUnitPrice.value.replace(strRegExDelimiter, "").replace(strRegExDecimal, ".")).toFixed(2) * Number(m_fldQuantity.value);
			}
			m_fldSubTotal.value = subPrice;
				
			//Format the SubTotal currency value
			m_fldSubTotal.value = parseFloat(m_fldSubTotal.value).toFixed(2);
			m_fldSubTotalb.innerHTML = g_MqRef.RESX['CURRENCY.SYMBOL'] + " " + parseFloat(m_fldSubTotal.value)
													.toFixed(2)
													.toString()
													.replace(/\./g, g_MqRef.RESX['CURRENCY.DECIMAL']) 
													.replace(/\B(?=(\d{3})+(?!\d))/g, g_MqRef.RESX['CURRENCY.THOUSANDS']);
			m_fldSubTotal.onchange();
		}
	}
	return;
}

function UnitPrice_SubTotal_CalcFlds()
{
	//Calculations for when updating the Quantity
	if (m_fldSubTotal && m_fldUnitPrice){
		if (m_fldQuantity.value != "")
		{
			if(m_fldUnitPrice.value != 0)
			{
				//If there's a value in Unit Price, recalculate subtotal with that value
				var subPrice;
				if(isNaN(m_fldUnitPrice.value) || isNaN(m_fldQuantity.value) || m_fldQuantity.value == "")
				{
					subPrice = Number("0.00");
				}
				else
				{
					subPrice = parseFloat(m_fldUnitPrice.value).toFixed(2) * Number(m_fldQuantity.value);
				}
				m_fldSubTotal.value= subPrice;
					
				//Format the SubTotal currency value
				m_fldSubTotal.value = parseFloat(m_fldSubTotal.value).toFixed(2);
				m_fldSubTotalb.innerHTML = g_MqRef.RESX['CURRENCY.SYMBOL'] + " " + parseFloat(m_fldSubTotal.value)
														.toFixed(2)
														.toString()
														.replace(/\./g, g_MqRef.RESX['CURRENCY.DECIMAL'])
														.replace(/\B(?=(\d{3})+(?!\d))/g, g_MqRef.RESX['CURRENCY.THOUSANDS']);
				m_fldSubTotal.onchange();
			}
			else
			{
				//else if the subtotal is already set, then recalculate the unit price
				var uPrice;
				if(isNaN(Number(m_fldSubTotal.value)) || isNaN(m_fldQuantity.value) || m_fldQuantity.value == 0 || m_fldQuantity.value == "")
				{
					uPrice = Number("0.00");
				}
				else
				{
					uPrice = Number(m_fldSubTotal.value) / Number(m_fldQuantity.value);
				}
				m_fldUnitPrice.value= uPrice;
					
				//Format the Unit Price currency value
				m_fldUnitPrice.value = parseFloat(m_fldUnitPrice.value).toFixed(2);
				m_fldUnitPriceb.innerHTML = g_MqRef.RESX['CURRENCY.SYMBOL'] + " " + parseFloat(m_fldUnitPrice.value)
														.toFixed(2)
														.toString()
														.replace(/\./g, g_MqRef.RESX['CURRENCY.DECIMAL'])
														.replace(/\B(?=(\d{3})+(?!\d))/g, g_MqRef.RESX['CURRENCY.THOUSANDS']);
				m_fldSubTotal.onchange();
			}
			
		}
	}
	return;
}

/********************************************************************/
function SetOnChange1(fld, funcCall)
{
	var strPrevFunc="";
	if(fld){
		if (fld.onchange){
			strPrevFunc=fld.onchange.valueOf();
		}
		fld.onchange=BuildFunction(funcCall,strPrevFunc);
	}
}

function BuildFunction(strNewContent,strContentFunction){
	var strBody;
	if (strContentFunction){		
		strBody="var objFunction=" +
					strContentFunction + ";" + 
					strNewContent + "objFunction();";
	}
	else{
		strBody=strNewContent;
	}
	
	var objFunc=new Function ( strBody );
	return objFunc;
}

